/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef __FUSION__LIST_H__
#define __FUSION__LIST_H__

typedef struct _FusionLink {
     struct _FusionLink *next;
     struct _FusionLink *prev;
} FusionLink;

void fusion_list_prepend       (FusionLink **list, FusionLink *link);
void fusion_list_remove        (FusionLink **list, FusionLink *link);
void fusion_list_move_to_front (FusionLink **list, FusionLink *link);


#define fusion_list_foreach(elem, list)                     \
     for (elem = (void*)(list);                             \
          elem;                                             \
          elem = (void*)(((FusionLink*)(elem))->next))

#define fusion_list_foreach_safe(elem, temp, list)                                             \
     for (elem = (void*)(list), temp = ((elem) ? (void*)(((FusionLink*)(elem))->next) : NULL); \
          elem;                                                                                \
          elem = (void*)(temp), temp = ((elem) ? (void*)(((FusionLink*)(elem))->next) : NULL))

#endif 

